//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdlib.h>

#pragma hdrstop

#include "memwatch.h"
#include "unit2.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"



//---------------------------------------------------------------------------

char readreg(unsigned int addr);


__fastcall TMemoryWatcherForm::TMemoryWatcherForm(TComponent* Owner)
        : TForm(Owner)
{


}
//---------------------------------------------------------------------------
void __fastcall TMemoryWatcherForm::AddClick(TObject *Sender)
{

        if (EditFrom->Text != "")
        {
                int from = StrToInt(EditFrom->Text);
                if (EditTo->Text == "")
                {
                        TListItem *pItem = WatchList->Items->Add();
                        pItem->Caption="0x" + IntToHex(from, 4);
                        pItem->SubItems->Add("");
                        pItem->SubItems->Add("");

                }
                else
                {
                        int to = StrToInt(EditTo->Text);
                        for (int i=from; i<=to; i++)
                        {
                                bool dupe=false;
                                for (int j=0; j<WatchList->Items->Count; j++)
                                {
                                        AnsiString temphex="0x" + IntToHex(i,4);
                                        if ((WatchList->Items->Item[j]->Caption.AnsiCompare(temphex))==0)
                                        {
                                                dupe=true;
                                                break;
                                        }
                                }
                                if (dupe==false)
                                {
                                        TListItem *pItem = WatchList->Items->Add ();
                                        pItem->Caption="0x" + IntToHex(i, 4);
                                        pItem->SubItems->Add("");
                                        pItem->SubItems->Add("");
                                }
                        }
                }
        }



}
//---------------------------------------------------------------------------

void __fastcall TMemoryWatcherForm::StartStopClick(TObject *Sender)
{
        if (StartStop->Caption == "Start")
        {
                StartStop->Caption="Stop";
                Timer1->Enabled=true;
        }
        else
        {
                StartStop->Caption="Start";
                Timer1->Enabled=false;
        }
}
//---------------------------------------------------------------------------


AnsiString byte2bin(unsigned char byte)
{
        // This is ghetto
        AnsiString binary;
        for (int j=0; j<=7; j++)
        {
                char temp=byte;
                bool bit=((temp<<j) & 0x80);
                if (bit)
                {
                        binary=binary + '1';
                }
                else
                {
                        binary=binary + '0';
                }
        }
        return binary;
}

void __fastcall TMemoryWatcherForm::Timer1Timer(TObject *Sender)
{
        Timer1->Enabled=false;
        for (int i=0; i<WatchList->Items->Count; i++)
        {
                unsigned char value;
                value=readreg(StrToInt(WatchList->Items->Item[i]->Caption));
                WatchList->Items->Item[i]->SubItems->Strings[1]=IntToHex(value, 2);
                WatchList->Items->Item[i]->SubItems->Strings[0]=byte2bin(value);
        }
        Timer1->Enabled=true;
}

//---------------------------------------------------------------------------

void __fastcall TMemoryWatcherForm::FormResize(TObject *Sender)
{
        // These numbers might have to be diddled with...
        WatchList->Width = MemoryWatcherForm->Width - 10;
        WatchList->Height = MemoryWatcherForm->Height - WatchList->Top - 30;
}
//---------------------------------------------------------------------------

void TMemoryWatcherForm::RemoveIt()
{
        // Remove all items that are selected
        bool timerstate=Timer1->Enabled;

        for (int i=WatchList->Items->Count-1; i>=0; i--)
        {
                if (WatchList->Items->Item[i]->Selected == true)
                {
                        WatchList->Items->Item[i]->Delete();
                }
        }
        Timer1->Enabled=timerstate;
}

void __fastcall TMemoryWatcherForm::RemoveClick(TObject *Sender)
{
        RemoveIt();
}
//---------------------------------------------------------------------------


void __fastcall TMemoryWatcherForm::EditIntervalExit(TObject *Sender)
{
        Timer1->Interval=EditInterval->Text.ToInt();
}
//---------------------------------------------------------------------------

void __fastcall TMemoryWatcherForm::WatchListKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
        // 46
        if (Key == 46) // Delete
        {
                RemoveIt();
        }
}
//---------------------------------------------------------------------------




void __fastcall TMemoryWatcherForm::Edit1Click(TObject *Sender)
{

        MemEdit->Show();


}
//---------------------------------------------------------------------------



